﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using KMotion_dotNet;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using KFlopWebNC.DOM_Helpers;
using System.ComponentModel;
using System.Threading;

namespace KFlopWebNC.Model
{ 
    public partial class DeviceInteropHandler
    {
        BackgroundWorker _StatusMonitor;

        public void StartMonitor()
        {
            if (_StatusMonitor == null)
            {
                _StatusMonitor = new BackgroundWorker();

                _StatusMonitor.WorkerSupportsCancellation = true;
                _StatusMonitor.DoWork += new DoWorkEventHandler(_StatusMonitor_DoWork);
                _StatusMonitor.RunWorkerAsync();
            }
        }

        public void _StatusMonitor_DoWork(object sender, DoWorkEventArgs e)
        {
            int interval = 100;
            int interval2 = 5;

            int secondary = interval2;
            IsConnected = _Controller.Connected;
            while (!_StatusMonitor.CancellationPending)
            {
                if (secondary < 1)
                {
                    UpdateSecondaryControls();
                    secondary = interval2;
                    IsConnected = _Controller.Connected;
                }
                UpdateAxisData();
                Thread.Sleep(interval);
                secondary--;
            }
            _StatusMonitor = null;
        }

        public void StopMonitor()
        {
            _StatusMonitor.CancelAsync();
        }



        public void UpdateSecondaryControls()
        {
            UpdateDocument(new Action(delegate()
            {
                UpdateConnectionStatus();
                UpdateFeedRate();
                UpdateJogRates();
           })); 
        }
        public void UpdateAxisData()
        {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;

            UpdateDocument(new Action(delegate()
            {
                if (IsConnected)
                {
                    _Controller.Interpreter.ReadCurMachinePosition(ref x, ref y, ref z, ref a, ref b, ref c);

 

                    //_Controller.Interpreter.ReadCurInterpreterPosition(ref x, ref y, ref z, ref a, ref b, ref c);


      


                }
                else
                {
                    x = _Controller.Interpreter.SetupParams.X_AxisPosition;
                    y = _Controller.Interpreter.SetupParams.Y_AxisPosition;
                    z = _Controller.Interpreter.SetupParams.Z_AxisPosition;
                    a = _Controller.Interpreter.SetupParams.A_AxisPosition;
                    b = _Controller.Interpreter.SetupParams.B_AxisPosition;
                    c = _Controller.Interpreter.SetupParams.C_AxisPosition;


         
                }


                if (_AxisContainer.ContainsKey("X"))
                {
                    _GuiHost.SetElementText(Elements.XDest, Math.Round(x, 3).ToString("000.000"));
                }
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _GuiHost.SetElementText(Elements.YDest, Math.Round(y, 3).ToString("000.000"));
                }
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _GuiHost.SetElementText(Elements.ZDest, Math.Round(z, 3).ToString("000.000"));
                }
                if (_AxisContainer.ContainsKey("A"))
                {
                    _GuiHost.SetElementText(Elements.ADest, Math.Round(a, 3).ToString("000.000"));
                }
                if (_AxisContainer.ContainsKey("B"))
                {
                    _GuiHost.SetElementText(Elements.BDest, Math.Round(b, 3).ToString("000.000"));
                }
                if (_AxisContainer.ContainsKey("C"))
                {
                    _GuiHost.SetElementText(Elements.CDest, Math.Round(c, 3).ToString("000.000"));
                }
           
          
            }));
        }

    }
}
